package ws.afterglo.audioPod;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.event.*;
import java.awt.*;
/**
 * @author Muti
 *
 */
public class PreferencesEditor{
    private Preferences    fPrefs = Preferences.userRoot().node("ws/afterglo/audioPod");
    
    private JDialog        frame;
    private JFrame         mainframe;
    
    private JTextField     userfield;
    private JPasswordField passfield;
    private JTextField     dbfield;
    private JTextField     apfield;
    private JTextField	   iTunesfield;
    private JTextField	   winampfield;
    private JCheckBox	   ceCheck;
    private JCheckBox	   iTCheck;
    private JCheckBox	   waCheck;
    private JCheckBox	   delPlaysCheck;
    private JCheckBox	   selectedCheck;
    private JLabel 		   cacheAndExitStatus;
    private JLabel		   iTunesStatus;
    private JLabel		   winampStatus;
    private JLabel		   delPlaysStatus;
    private JLabel		   selectedStatus;
    private JButton		   browsebuttoniTunes;
    private JButton		   browsebuttonWinamp;
    
    public PreferencesEditor(JFrame frame){
    	mainframe=frame;
    }
    
    public void buildUI(){
    	this.frame=new JDialog(mainframe, true);
        this.frame.setTitle("Preferences...");
        
        this.addElements();
        this.matchPreferences(); //gets preferences from AudioPod and updates UI
        
        this.frame.pack();
        
        int x=(int)(Toolkit.getDefaultToolkit().getScreenSize().width/2-frame.getWidth()/2);
        int y=(int)(Toolkit.getDefaultToolkit().getScreenSize().height/2-frame.getHeight()/2);
        frame.setLocation(x,y);
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }
    
    private void addElements(){
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));
        p.setOpaque(true);
        this.frame.setContentPane(p);
        
        //Username and password panel
        JPanel p2= new JPanel();
        p2.setLayout(new SpringLayout());
        
        TitledBorder b2=BorderFactory.createTitledBorder("AudioScrobbler/Last.fm:");
        p2.setBorder(b2);
        p2.setToolTipText("<html>This entry is used if you want to <b>Submit Tracks</b> to AudioScrobbler/Last.fm");
        
        JLabel userlabel = new JLabel("Username:");
        p2.add(userlabel);
        this.userfield = new JTextField();
        p2.add(this.userfield);
        
        JLabel passlabel = new JLabel("Password:");
        p2.add(passlabel);
        this.passfield = new JPasswordField();
        p2.add(this.passfield);
        
        SpringUtilities.makeCompactGrid(p2, 2, 2, 5, 4, 3, 4);
        p.add(p2);
       
        //iPod Panel
        JPanel p1=new JPanel();
        p1.setLayout(new SpringLayout());
        
        TitledBorder b1=BorderFactory.createTitledBorder("iPod:");
        p1.setBorder(b1);
        p1.setToolTipText("<html>Path of the iTunesDB:<br>Located on your iPod, e.g. <b>M</b>:\\iPod_Control\\iTunes,<br>where M is the drive letter of your iPod.");
        
        JLabel dblabel = new JLabel("Location of iTunesDB:");
        p1.add(dblabel);
        this.dbfield = new JTextField();
        this.dbfield.setPreferredSize(new Dimension(200,20));
        p1.add(this.dbfield);
        
        JButton BrowseButtoniPod = new JButton("Browse..");
        BrowseButtoniPod.setMnemonic(KeyEvent.VK_B);
        BrowseButtoniPod.addActionListener(new BrowseButtonListeneriPod());
        p1.add(BrowseButtoniPod);
        SpringUtilities.makeCompactGrid(p1, 1, 3, 5, 4, 3, 4);
        p.add(p1);
        
        //iPod Panel
        JPanel p9=new JPanel();
        p9.setLayout(new SpringLayout());
        
        TitledBorder b9=BorderFactory.createTitledBorder("AllPlays:");
        p9.setBorder(b9);
        p9.setToolTipText("<html>Path of the iTunesDB:<br>Located on your iPod, e.g. <b>M</b>:\\iPod_Control\\iTunes,<br>where M is the drive letter of your iPod.");
        
        JLabel aplabel = new JLabel("Path to AllPlaysiPod.xml:");
        p9.add(aplabel);
        this.apfield = new JTextField();
        this.apfield.setPreferredSize(new Dimension(200,20));
        p9.add(this.apfield);
        
        JButton BrowseButtonAP = new JButton("Browse..");
        BrowseButtonAP.setMnemonic(KeyEvent.VK_B);
        BrowseButtonAP.addActionListener(new BrowseButtonListenerAP());
        p9.add(BrowseButtonAP);
        SpringUtilities.makeCompactGrid(p9, 1, 3, 5, 4, 3, 4);
        p.add(p9);
        
        //iTunes Panel
        JPanel p4=new JPanel();
        p4.setLayout(new SpringLayout());
        
        TitledBorder b4=BorderFactory.createTitledBorder("iTunes:");
        p4.setBorder(b4);
        p4.setToolTipText("Enable if you want to use audioPod with iTunes");
        
        JPanel p41=new JPanel();
        iTCheck=new JCheckBox();
        iTCheck.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if(iTCheck.isSelected()){
                	iTunesStatus.setText("Enabled");
                }else{
                	iTunesStatus.setText("Disabled");
                }
            }
        });
        p41.add(iTCheck);
        iTunesStatus=new JLabel();
        iTunesStatus.addMouseListener(new MouseListener(){
        	public void mouseClicked(MouseEvent e){
                if(iTunesStatus.getText().equals("Disabled")){
                	iTCheck.setSelected(true);
                	iTunesStatus.setText("Enabled");
                	iTunesfield.setEditable(true);
                	browsebuttoniTunes.setEnabled(true);
                }else{
                	iTCheck.setSelected(false);
                	iTunesStatus.setText("Disabled");
                	iTunesfield.setEditable(false);
                	browsebuttoniTunes.setEnabled(false);
                }
        	}
        	public void mouseEntered(MouseEvent e){}
        	public void mouseExited(MouseEvent e){}
        	public void mouseReleased(MouseEvent e){}
        	public void mousePressed(MouseEvent e){}
        });
        p41.add(iTunesStatus);
        
        p4.add(p41);
        p4.add(new JLabel());
        p4.add(new JLabel());
        
        JLabel exelabel = new JLabel("Location of iTunes.exe:");
        p4.add(exelabel);
        this.iTunesfield = new JTextField();
        this.iTunesfield.setPreferredSize(new Dimension(200,20));
        p4.add(this.iTunesfield);
        
        browsebuttoniTunes = new JButton("Browse..");
        browsebuttoniTunes.setMnemonic(KeyEvent.VK_R);
        browsebuttoniTunes.addActionListener(new BrowseButtonListenerITunes());
        p4.add(browsebuttoniTunes);
        SpringUtilities.makeCompactGrid(p4, 2, 3, 5, 4, 3, 4);
        p.add(p4);
        
        //Winamp Panel
        JPanel p6=new JPanel();
        p6.setLayout(new SpringLayout());
        
        TitledBorder b6=BorderFactory.createTitledBorder("Winamp:");
        p6.setBorder(b6);
        p6.setToolTipText("Enable if you want to use audioPod with Winamp");
        
        JPanel p61=new JPanel();
        waCheck=new JCheckBox();
        waCheck.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if(waCheck.isSelected()){
                	winampStatus.setText("Enabled");
                }else{
                	winampStatus.setText("Disabled");
                }
            }
        });
        p61.add(waCheck);
        winampStatus=new JLabel();
        winampStatus.addMouseListener(new MouseListener(){
        	public void mouseClicked(MouseEvent e){
                if(winampStatus.getText().equals("Disabled")){
                	browsebuttonWinamp.setEnabled(true);
                	winampfield.setEditable(true);
                	waCheck.setSelected(true);
                	winampStatus.setText("Enabled");
                }else{
                	browsebuttonWinamp.setEnabled(false);
                	winampfield.setEditable(false);
                	waCheck.setSelected(false);
                	winampStatus.setText("Disabled");
                }
        	}
        	public void mouseEntered(MouseEvent e){}
        	public void mouseExited(MouseEvent e){}
        	public void mouseReleased(MouseEvent e){}
        	public void mousePressed(MouseEvent e){}
        });
        p61.add(winampStatus);
        
        p6.add(p61);
        p6.add(new JLabel());
        p6.add(new JLabel());
        
        JLabel walabel = new JLabel("Location of Winamp.exe:");
        p6.add(walabel);
        this.winampfield = new JTextField();
        this.winampfield.setPreferredSize(new Dimension(200,20));
        p6.add(this.winampfield);
        
        browsebuttonWinamp = new JButton("Browse..");
        browsebuttonWinamp.setMnemonic(KeyEvent.VK_W);
        browsebuttonWinamp.addActionListener(new BrowseButtonListenerWinamp());
        p6.add(browsebuttonWinamp);
        SpringUtilities.makeCompactGrid(p6, 2, 3, 5, 4, 3, 4);
        p.add(p6);
        
        //Options Panel
        JPanel p3=new JPanel();
        p3.setLayout(new SpringLayout());
        
        TitledBorder b3=BorderFactory.createTitledBorder("Options:");
        p3.setBorder(b3);
        p3.setToolTipText("<html>If enabled, the program will launch the selected player and<br>close itself after having submitted/cached the tracks");
        
        JLabel j3=new JLabel("Submit/Cache Tracks > Launch Player > Exit: ");
        p3.add(j3);
        JPanel p31=new JPanel();
        ceCheck=new JCheckBox();
        ceCheck.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if(ceCheck.isSelected()){
                	cacheAndExitStatus.setText("Enabled");
                }else{
                	cacheAndExitStatus.setText("Disabled");
                }
            }
        });
        p31.add(ceCheck);
        cacheAndExitStatus=new JLabel();
        cacheAndExitStatus.addMouseListener(new MouseListener(){
        	public void mouseClicked(MouseEvent e){
                if(cacheAndExitStatus.getText().equals("Disabled")){
                	ceCheck.setSelected(true);
                	cacheAndExitStatus.setText("Enabled");
                }else{
                	ceCheck.setSelected(false);
                	cacheAndExitStatus.setText("Disabled");
                }
        	}
        	public void mouseEntered(MouseEvent e){}
        	public void mouseExited(MouseEvent e){}
        	public void mouseReleased(MouseEvent e){}
        	public void mousePressed(MouseEvent e){}
        });
        p31.add(cacheAndExitStatus);       
        p3.add(p31);
        
        //Delete Play Counts on iPod
        JLabel j4=new JLabel("Delete the 'Play Counts' File on the iPod: ");
        j4.setToolTipText("<html>If enabled, you won't have to sync with any<br>other player to get rid of the played tracks");
        p3.add(j4);
        JPanel p32=new JPanel();
        delPlaysCheck=new JCheckBox();
        delPlaysCheck.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if(delPlaysCheck.isSelected()){
                	delPlaysStatus.setText("Enabled");
                }else{
                	delPlaysStatus.setText("Disabled");
                }
            }
        });
        p32.add(delPlaysCheck);
        delPlaysStatus=new JLabel();
        delPlaysStatus.addMouseListener(new MouseListener(){
        	public void mouseClicked(MouseEvent e){
                if(delPlaysStatus.getText().equals("Disabled")){
                	delPlaysCheck.setSelected(true);
                	delPlaysStatus.setText("Enabled");
                }else{
                	delPlaysCheck.setSelected(false);
                	delPlaysStatus.setText("Disabled");
                }
        	}
        	public void mouseEntered(MouseEvent e){}
        	public void mouseExited(MouseEvent e){}
        	public void mouseReleased(MouseEvent e){}
        	public void mousePressed(MouseEvent e){}
        });
        p32.add(delPlaysStatus);
        p3.add(p32);
        
//      Delete Play Counts on iPod
        JLabel j5=new JLabel("Submit/Cache only selected tracks: ");
        j5.setToolTipText("<html>If enabled, only the selected tracks will be<br>submitted or cached. All the others will be lost!");
        p3.add(j5);
        JPanel p52=new JPanel();
        selectedCheck=new JCheckBox();
        selectedCheck.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if(selectedCheck.isSelected()){
                	selectedStatus.setText("Enabled");
                }else{
                	selectedStatus.setText("Disabled");
                }
            }
        });
        p52.add(selectedCheck);
        selectedStatus=new JLabel();
        selectedStatus.addMouseListener(new MouseListener(){
        	public void mouseClicked(MouseEvent e){
                if(selectedStatus.getText().equals("Disabled")){
                	selectedCheck.setSelected(true);
                	selectedStatus.setText("Enabled");
                }else{
                	selectedCheck.setSelected(false);
                	selectedStatus.setText("Disabled");
                }
        	}
        	public void mouseEntered(MouseEvent e){}
        	public void mouseExited(MouseEvent e){}
        	public void mouseReleased(MouseEvent e){}
        	public void mousePressed(MouseEvent e){}
        });
        p52.add(selectedStatus);
        p3.add(p52);
        
        SpringUtilities.makeCompactGrid(p3, 3, 2, 5, 2, 3, 4);
        p.add(p3);
        
        JPanel p5=new JPanel();
        
        JButton findPathsButton=new JButton("Find Paths");
        findPathsButton.setMnemonic(KeyEvent.VK_F);
        findPathsButton.setToolTipText("Will try to find the paths for iTunesDB, iTunes.exe and Winamp.exe");
        findPathsButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
            	
            	//scan for iTunesDB
            	File itdb=new File(dbfield.getText());
            	File itdbf=new File(dbfield.getText()+"\\Play Counts");
            	boolean dbfound=false;
            	if(itdbf.isFile() || itdb.isFile() || itdb.getAbsolutePath().endsWith(":\\iPod_Control\\iTunes")){
            		iTunesfield.setText(itdb.getAbsolutePath());
            		dbfound=true;
            	}else{
	        	    for(int i=(int)'B';i<=(int)'Z';i++){
	        	    	itdb=new File((char)i+":\\iPod_Control\\iTunes\\iTunesDB");
	        	    	if(itdb.isFile()){
	        	    		dbfield.setText(itdb.getParent());
	        	    		dbfound=true;
	        	    		break;
	        	    	}
	        	    }
	        	    if(!dbfound){
	        	    	JOptionPane.showMessageDialog(new JFrame(),
	        	    		"iTunesDB location not found. Are you sure your iPod is plugged in?");
	        	    	dbfield.setText("<iPod iTunes Database Location>");
	        	    }
            	}
            	
        	    //scan for iTunes
            	File itp=new File(iTunesfield.getText());
            	File itpf=new File(iTunesfield.getText()+"\\iTunes.exe");
            	if(itp.isFile())
            		iTunesfield.setText(itp.getParent());
            	else if(itpf.isFile())
            		iTunesfield.setText(itpf.getParent());
            	else{
        	    	for(int i=(int)'B';i<=(int)'Z';i++){
        	    		itp=new File((char)i+":\\Program Files\\iTunes\\iTunes.exe");
        	    		if(itp.isFile()){
        	    			iTunesfield.setText(itp.getParent());
        	    			break;
        	    		}
        	    	}
            	}
            	
            	//scan for winamp
            	File wap=new File(winampfield.getText());
            	File wapf=new File(winampfield.getText()+"\\winamp.exe");
            	if(wap.isFile()){
            		winampfield.setText(wap.getParent());
            	}else if(wapf.isFile()){
            		winampfield.setText(wapf.getParent());
            	}else{
        	    	for(int i=(int)'B';i<=(int)'Z';i++){
        	    		wap=new File((char)i+":\\Program Files\\Winamp\\winamp.exe");
        	    		if(wap.isFile()){
        	    			winampfield.setText(wap.getParent());
        	    			break;
        	    		}
        	    	}
            	}
            }
        });
        p5.add(findPathsButton);
        
        JButton okbutton = new JButton("OK");
        okbutton.setMnemonic(KeyEvent.VK_O);
        okbutton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                savePreferences();
                frame.dispose();
            }
        });
        p5.add(okbutton);
        
        JButton cancelbutton = new JButton("Cancel");
        cancelbutton.setMnemonic(KeyEvent.VK_C);
        cancelbutton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                frame.dispose();
            }
        });
        p5.add(cancelbutton);
        
        p.add(p5);
    }
    
    private void matchPreferences() {
        this.userfield.setText(fPrefs.get("Username", "<Username>"));
        this.passfield.setText(fPrefs.get("Password", ""));
        this.dbfield.setText(fPrefs.get("iTunes Path", "<iPod iTunes Database Location>"));
        this.apfield.setText(fPrefs.get("AllPlays Path", "<AllPlays XML Location>"));
        this.iTunesfield.setText(fPrefs.get("iT Path", "   < Enter iTunes path >   "));
        this.winampfield.setText(fPrefs.get("wa Path", "   < Enter Winamp path >   "));
        this.winampStatus.setText(fPrefs.get("Winamp Status", "Disabled"));
        if(fPrefs.get("iTunes Status", "Enabled").equals("Enabled")){
        	this.iTunesStatus.setText("Enabled");
        	this.iTCheck.setSelected(true);
        	this.iTunesfield.setEditable(true);
        	this.browsebuttoniTunes.setEnabled(true);
        }else{
        	this.iTunesStatus.setText("Disabled");
        	this.iTCheck.setSelected(false);
        	this.iTunesfield.setEditable(false);
        	this.browsebuttoniTunes.setEnabled(false);
        }
        if(fPrefs.get("Winamp Status", "Disabled").equals("Enabled")){
        	this.winampStatus.setText("Enabled");
        	this.waCheck.setSelected(true);
        	this.winampfield.setEditable(true);
        	this.browsebuttonWinamp.setEnabled(true);
        }else{
        	this.winampStatus.setText("Disabled");
        	this.waCheck.setSelected(false);
        	this.winampfield.setEditable(false);
        	this.browsebuttonWinamp.setEnabled(false);
        }
        if(fPrefs.get("ceCheck", "Disabled").equals("Enabled")){
        	this.ceCheck.setSelected(true);
        	this.cacheAndExitStatus.setText("Enabled");
        }else{
        	this.ceCheck.setSelected(false);
        	this.cacheAndExitStatus.setText("Disabled");
        }
        if(fPrefs.get("delPlays", "Disabled").equals("Enabled")){
        	this.delPlaysCheck.setSelected(true);
        	this.delPlaysStatus.setText("Enabled");
        }else{
        	this.delPlaysCheck.setSelected(false);
        	this.delPlaysStatus.setText("Disabled");
        }
        if(fPrefs.get("Selected Status", "Disabled").equals("Enabled")){
        	this.selectedCheck.setSelected(true);
        	this.selectedStatus.setText("Enabled");
        }else{
        	this.selectedCheck.setSelected(false);
        	this.selectedStatus.setText("Disabled");
        }
    }
    
    private void savePreferences() {
        fPrefs.put("Username", this.userfield.getText());
        fPrefs.put("Password", new String(this.passfield.getPassword()));
        fPrefs.put("iTunes Path", this.dbfield.getText());
        fPrefs.put("AllPlays Path", this.apfield.getText());
        fPrefs.put("iT Path", this.iTunesfield.getText());
        fPrefs.put("wa Path", this.winampfield.getText());
        fPrefs.put("iTunes Status", this.iTunesStatus.getText());
        fPrefs.put("Winamp Status", this.winampStatus.getText());
        fPrefs.put("Selected Status", this.selectedStatus.getText());
        fPrefs.put("ceCheck", this.cacheAndExitStatus.getText());
        fPrefs.put("delPlays", this.delPlaysStatus.getText());
        try {
            fPrefs.flush();
        } catch(Exception e) {
            Logger logger = Logger.getLogger(this.getClass().getPackage().getName());
            logger.log(Level.WARNING, "Unable to save preferences: " + e.toString());
        }
        AudioPod.recentplayed=new ArrayList();
        AudioPod.ParsePlayCounts();
        AudioPod.UI.newTrackListAvailable();
    }
    
    private class BrowseButtonListenerAP implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser();
            fc.setFileHidingEnabled(false);
            File d=new File(apfield.getText());
            if(d.isDirectory())
            	fc.setCurrentDirectory(d);
            int returnVal = fc.showOpenDialog(frame);
            
            if(returnVal == JFileChooser.APPROVE_OPTION) {
                File f = fc.getSelectedFile();
                apfield.setText(f.getParent());
            }
        }
    }
    
    private class BrowseButtonListeneriPod implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser();
            fc.setFileHidingEnabled(false);
            fc.setFileFilter(new ItunesdbFilter());
            File d=new File(dbfield.getText());
            if(d.isDirectory())
            	fc.setCurrentDirectory(d);
            int returnVal = fc.showOpenDialog(frame);
            
            if(returnVal == JFileChooser.APPROVE_OPTION) {
                File f = fc.getSelectedFile();
                dbfield.setText(f.getParent());
            }
        }
    }
    
    private class BrowseButtonListenerITunes implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser();
            fc.setFileHidingEnabled(false);
            File d=new File(iTunesfield.getText());
            if(d.isDirectory())
            	fc.setCurrentDirectory(d);
            else if(d.isFile())
            	fc.setCurrentDirectory(d.getParentFile());
            fc.setFileFilter(new ExeFileFilter());
            int returnVal = fc.showOpenDialog(frame);
            
            if(returnVal == JFileChooser.APPROVE_OPTION) {
                File f = fc.getSelectedFile();
                iTunesfield.setText(f.getParent());
            }
        }
    }
    
    private class BrowseButtonListenerWinamp implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser();
            fc.setFileHidingEnabled(false);
            File d=new File(winampfield.getText());
            if(d.isDirectory())
            	fc.setCurrentDirectory(d);
            else if(d.isFile())
            	fc.setCurrentDirectory(d.getParentFile());
            fc.setFileFilter(new ExeFileFilter());
            int returnVal = fc.showOpenDialog(frame);
            
            if(returnVal == JFileChooser.APPROVE_OPTION) {
                File f = fc.getSelectedFile();
                winampfield.setText(f.getParent());
            }
        }
    }
}
